/******************************************************************************
 * %Id: vout_bridge_data.h,v 1.14 2009/07/28 07:07:23 morimoto Exp $
 *
 * FileName		:vout_bridge_data.h
 *
 * Description	:Definition header of data used in bridge
 *
 *
 * Copyright	:Panasonic Corporation.
 *
 *****************************************************************************/
#ifndef	_VOUT_BRIDGE_DATA_H_
#define	_VOUT_BRIDGE_DATA_H_

#include <linux/iosc/iosc-devices.h>

#define VOUT_MAX_FD_NAME                256
#define VOUT_MACROVISION_DATA_LENGTH    18
#define	VOUT_BRIDGE_LVDS_TX_NUM			(4)
#define	VOUT_BRIDGE_LOSD_PLANE_NUM		(2)
#define	VOUT_BRIDGE_GLASS_NUM			(3)

typedef struct {
    int cmd;
    int (*handler) (int, unsigned int, void *);
} vout_command_t;


typedef struct _vout_arg_t {
    int						error;
} vout_arg_t;


typedef struct _vout_lvds_mute_arg_t {
    int						error;
    unsigned int			onoff;
} vout_lvds_mute_arg_t;


typedef struct _vout_lvds_pin_assign_t {
	unsigned int			type;
	unsigned int			assign;
	unsigned int			td6;
	unsigned int			te6;
} vout_lvds_pin_assign_t;

typedef struct _vout_lvds_lrid_t {
	unsigned int			onoff;
	unsigned int			mode;
} vout_lvds_lrid_t;

typedef struct _vout_lvds_mode_t {
	unsigned int			output;
	unsigned int			clk_speed;
} vout_lvds_mode_t;

typedef struct _vout_lvds_tx_t {
	unsigned int			enable;
	unsigned int			select;
} vout_lvds_tx_t;

typedef struct _vout_lvds_tx_adj_t {
	unsigned int			clkedge_inv;
	unsigned int			posneg_inv;
	unsigned int			clk_amp;
	unsigned int			data_amp;
	unsigned int			endian_swap;
	unsigned int			clkline_swap;
} vout_lvds_tx_adj_t;

typedef struct _vout_lvds_config_t {
	vout_lvds_pin_assign_t		video;
	vout_lvds_lrid_t			lrid;
	vout_lvds_mode_t			mode;
	vout_lvds_tx_t				tx[VOUT_BRIDGE_LVDS_TX_NUM];
	vout_lvds_tx_adj_t			adjust;
} vout_lvds_config_t;

typedef struct _vout_lvds_config_arg_t {
    int						error;
    vout_lvds_config_t		data;
} vout_lvds_config_arg_t;


typedef struct _vout_minilvds_output_t {
	unsigned int			format;
	unsigned int			vcom;
	unsigned int			bit;
	unsigned int			port;
} vout_minilvds_output_t;

typedef struct _vout_minilvds_config_t {
	vout_lvds_pin_assign_t		video;
	vout_lvds_lrid_t			lrid;
	vout_lvds_mode_t			mode;
	vout_lvds_tx_t				tx[VOUT_BRIDGE_LVDS_TX_NUM];
	vout_lvds_tx_adj_t			adjust;
	vout_minilvds_output_t		minilvds;
} vout_minilvds_config_t;

typedef struct _vout_minilvds_config_arg_t {
    int						error;
    vout_minilvds_config_t	data;
} vout_minilvds_config_arg_t;


typedef struct _vout_format_width_t {
	unsigned int			width_h;
	unsigned int			width_v;
} vout_format_width_t;

typedef struct _vout_format_active_t {
	unsigned int			start_h;
	unsigned int			start_v;
	unsigned int			width_h;
	unsigned int			width_v;
} vout_format_active_t;

typedef struct _vout_input_format_t {
	vout_format_width_t		all;
	unsigned int			v_frequency;
	unsigned int			signal_form;
} vout_input_format_t;

typedef struct _vout_output_format_t {
	vout_format_width_t		sync;
	vout_format_active_t	active;
	vout_format_width_t		all;
	unsigned int			sync_polarity;
	unsigned int			clock_frequency;
	unsigned int			signal_form;
} vout_output_format_t;

typedef struct _vout_format_mode_t {
	unsigned int			revscan;
} vout_format_mode_t;

typedef struct _vout_format_config_t {
	vout_input_format_t		input;
	vout_output_format_t	output;
	unsigned int			ssc;
	vout_format_mode_t		mode;
} vout_format_config_t;

typedef struct _vout_output_format_arg_t{
	int						error;
	vout_format_config_t	data;
} vout_format_config_arg_t;


typedef struct _vout_vprotect_t {
	unsigned int			onoff;
	unsigned int			margin_min;
	unsigned int			margin_max;
} vout_vprotect_t;

typedef struct _vout_vprotect_arg_t{
	int						error;
	vout_vprotect_t			data;
} vout_vprotect_arg_t;


typedef struct _vout_losd_blend_t{
	unsigned int			plane[VOUT_BRIDGE_LOSD_PLANE_NUM];
} vout_losd_blend_t;

typedef struct _vout_losd_blend_arg_t{
	int						error;
	vout_losd_blend_t		data;
} vout_losd_blend_arg_t;


typedef struct _vout_pwm_mute_arg_t {
    int						error;
    unsigned int			onoff;
} vout_pwm_mute_arg_t;


typedef struct _vout_glass_config_t {
    unsigned int			duty_ctrl;
    unsigned int			lr_mode;
    unsigned int			duty;
    unsigned int			vdelay;
    unsigned int			hdelay;
    unsigned int			glass_info[VOUT_BRIDGE_GLASS_NUM];
} vout_glass_config_t;

typedef struct _vout_glass_config_arg_t {
    int						error;
    vout_glass_config_t		data;
} vout_glass_config_arg_t;



typedef struct _vout_sync_output_format_t{
	unsigned int			sync_polarity;
	unsigned int			format_type;
} vout_sync_output_format_t;

typedef struct _vout_sync_config_t{
	vout_input_format_t				input;
	vout_sync_output_format_t	output;
} vout_sync_config_t;

typedef struct _vout_sync_config_arg_t {
  int      							error;
  vout_sync_config_t 				data;
} vout_sync_config_arg_t;

typedef struct _vout_digital_pin_assign_t {
  unsigned int   		type;
  unsigned int    		assign;
  unsigned int  		fid_pin_assign;
} vout_digital_pin_assign_t;

typedef struct _vout_digital_pin_polarity_t {
  unsigned int  					polarity_fid;
  unsigned int  					polarity_de;
} vout_digital_pin_polarity_t;

typedef struct _vout_digital_pin_config_t {
  vout_digital_pin_assign_t   		pin_assign;
  vout_digital_pin_polarity_t    	pin_polarity;
  unsigned int  					freq;
} vout_digital_pin_config_t;

typedef struct _vout_digital_pin_config_arg_t {
  int      							error;
  vout_digital_pin_config_t 		data;
} vout_digital_pin_config_arg_t;


typedef struct _vout_digital_mute_config_arg_t {
  int      							error;
  unsigned int						onoff;
} vout_digital_mute_config_arg_t;


#endif                          /* _VOUT_BRIDGE_DATA_H_ */

/* end of vout_bridge_data.h */
